<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Database\Eloquent\Model;

class CreateForeignKeys extends Migration {

	public function up()
	{
		Schema::table('regular_cards', function(Blueprint $table) {
			$table->foreign('currency_id')->references('id')->on('currencies')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('card_merchant', function(Blueprint $table) {
			$table->foreign('card_id')->references('id')->on('regular_cards')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('card_merchant', function(Blueprint $table) {
			$table->foreign('merchant_id')->references('id')->on('merchants')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('home_runs', function(Blueprint $table) {
			$table->foreign('card_id')->references('id')->on('regular_cards')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('home_runs', function(Blueprint $table) {
			$table->foreign('user_id')->references('id')->on('users')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('card_user', function(Blueprint $table) {
			$table->foreign('user_id')->references('id')->on('users')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('card_user', function(Blueprint $table) {
			$table->foreign('card_id')->references('id')->on('regular_cards')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('transactions', function(Blueprint $table) {
			$table->foreign('user_id')->references('id')->on('users')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('transactions', function(Blueprint $table) {
			$table->foreign('card_id')->references('id')->on('regular_cards')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('card_transaction', function(Blueprint $table) {
			$table->foreign('card_id')->references('id')->on('regular_cards')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('card_transaction', function(Blueprint $table) {
			$table->foreign('trasaction_id')->references('id')->on('transactions')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
	}

	public function down()
	{
		Schema::table('regular_cards', function(Blueprint $table) {
			$table->dropForeign('regular_cards_currency_id_foreign');
		});
		Schema::table('card_merchant', function(Blueprint $table) {
			$table->dropForeign('card_merchant_card_id_foreign');
		});
		Schema::table('card_merchant', function(Blueprint $table) {
			$table->dropForeign('card_merchant_merchant_id_foreign');
		});
		Schema::table('home_runs', function(Blueprint $table) {
			$table->dropForeign('home_runs_card_id_foreign');
		});
		Schema::table('home_runs', function(Blueprint $table) {
			$table->dropForeign('home_runs_user_id_foreign');
		});
		Schema::table('card_user', function(Blueprint $table) {
			$table->dropForeign('card_user_user_id_foreign');
		});
		Schema::table('card_user', function(Blueprint $table) {
			$table->dropForeign('card_user_card_id_foreign');
		});
		Schema::table('transactions', function(Blueprint $table) {
			$table->dropForeign('transactions_user_id_foreign');
		});
		Schema::table('transactions', function(Blueprint $table) {
			$table->dropForeign('transactions_card_id_foreign');
		});
		Schema::table('card_transaction', function(Blueprint $table) {
			$table->dropForeign('card_transaction_card_id_foreign');
		});
		Schema::table('card_transaction', function(Blueprint $table) {
			$table->dropForeign('card_transaction_trasaction_id_foreign');
		});
	}
}