<?php

namespace App;

use Illuminate\Database\Eloquent\Model;

class Order extends Model 
{

    protected $table = 'orders';
    public $timestamps = true;
    protected $fillable = array('name', 'address', 'method_payment', 'state', 'price', 'client_id', 'restaurant_id', 'cost', 'delivery_cost', 'total', 'commission', 'net');

    public function restaurant()
    {
        return $this->belongsTo('Restaurant');
    }

    public function client()
    {
        return $this->belongsTo('Client');
    }

    public function notifications()
    {
        return $this->hasMany('Notification');
    }

    public function products()
    {
        return $this->belongsToMany('\Order');
    }

}