<?php

namespace App;

use Illuminate\Database\Eloquent\Model;

class AffiliateClient extends Model 
{

    protected $table = 'affiliate_clients';
    public $timestamps = true;
    protected $fillable = array('name', 'mobile', 'phone', 'address', 'email', 'total_price', 'admin_percentage', 'tax_percentage', 'profit', 'extra_tax_type', 'extra_tax_name', 'extra_tax_value', 'discount_type', 'discount_name', 'discount_value', 'affiliate_transfer_to_admin_id', 'yellow_page_department_id', 'city_id', 'affiliate_id');

    public function yellowPageDepartment()
    {
        return $this->belongsTo('YellowPageDepartment');
    }

    public function city()
    {
        return $this->belongsTo('City');
    }

    public function affiliate()
    {
        return $this->belongsTo('Affiliate');
    }

    public function affiliateClientTransfer()
    {
        return $this->belongsTo('AffiliateTransferToAdmin', 'affiliate_transfer_to_admin_id');
    }

    public function yellow_services_affiliate_clients()
    {
        return $this->hasMany('Yellow_services_affiliate_clients');
    }

    public function element()
    {
        return $this->belongsTo('Element');
    }

}