<?php

namespace App;

use Illuminate\Database\Eloquent\Model;

class City extends Model 
{

    protected $table = 'cities';
    public $timestamps = true;
    protected $fillable = array('name', 'province_id');

    public function province()
    {
        return $this->belongsTo('Province', 'province_id');
    }

    public function affiliates()
    {
        return $this->hasMany('Affiliate');
    }

    public function users()
    {
        return $this->hasMany('User');
    }

    public function post()
    {
        return $this->hasMany('Post');
    }

    public function cvs()
    {
        return $this->hasMany('Cv');
    }

}