<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateSkillsTable extends Migration {

	public function up()
	{
		Schema::create('skills', function(Blueprint $table) {
			$table->increments('id');
			$table->timestamps();
			$table->string('skill')->nullable();
			$table->enum('skills_level', array('Intermediate', 'Good', 'VeryGood', 'Exellent'));
			$table->bigInteger('cv_id')->unsigned();
		});
	}

	public function down()
	{
		Schema::drop('skills');
	}
}