<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateAffiliatesTransfersToAdminTable extends Migration {

	public function up()
	{
		Schema::create('affiliates_transfers_to_admin', function(Blueprint $table) {
			$table->increments('id');
			$table->timestamps();
			$table->string('transfer_number', 255);
			$table->date('transfer_date');
			$table->double('amount');
			$table->enum('receive_status_by_admin', array('received', 'pending'));
			$table->bigInteger('affiliate_id')->unsigned();
		});
	}

	public function down()
	{
		Schema::drop('affiliates_transfers_to_admin');
	}
}