<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateStoresTable extends Migration {

	public function up()
	{
		Schema::create('stores', function(Blueprint $table) {
			$table->increments('id');
			$table->timestamps();
			$table->string('name');
			$table->text('details')->nullable();
			$table->string('image')->nullable();
			$table->json('phones')->nullable();
			$table->string('address')->nullable();
			$table->string('email')->nullable();
			$table->string('facebook')->nullable();
			$table->string('instagram')->nullable();
			$table->string('website')->nullable();
			$table->string('whats_up')->nullable();
			$table->bigInteger('store_category_id')->unsigned();
			$table->bigInteger('province_id')->unsigned();
		});
	}

	public function down()
	{
		Schema::drop('stores');
	}
}