<?php

namespace App\Models;

class Donation_Request extends Eloquent {

	protected $table = 'donation_requests';
	public $timestamps = true;
	protected $fillable = array('paitent_name', 'patient_phone', 'city_id', 'hospital_name', 'blood_type_id', 'patient_age', 'bags_num', 'hospital_address', 'details', 'latitude', 'longitude', 'client_id');

	public function notification()
	{
		return $this->hasMany('App\Models\Notification');
	}

	public function city()
	{
		return $this->belongsTo('App\Models\City');
	}

	public function Blood_type()
	{
		return $this->belongsTo('App\Models\Blood_Type');
	}

	public function client()
	{
		return $this->belongsTo('App\Models\Client');
	}

}