<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateEventClosureTable extends Migration {

	public function up()
	{
		Schema::create('event_closure', function(Blueprint $table) {
			$table->increments('id');
			$table->timestamps();
			$table->softDeletes();
			$table->string('description')->nullable();
			$table->datetime('closure_date')->nullable();
			$table->integer('event_id')->nullable();
			$table->integer('equipment_id')->nullable();
			$table->datetime('due_date')->nullable();
			$table->enum('status', array('closed', 'ongoing', 'open'))->nullable();
		});
	}

	public function down()
	{
		Schema::drop('event_closure');
	}
}