<?php

namespace Api;

use Illuminate\Database\Eloquent\SoftDeletingTrait;

class Project extends Eloquent {

	protected $table = 'project';
	public $timestamps = true;

	use SoftDeletingTrait;

	protected $dates = ['deleted_at'];
	protected $fillable = array('name', 'code', 'pm', 'hse_manager', 'owner', 'sector_id', 'status');

	public function sector()
	{
		return $this->belongsTo('Sector', 'sector_id');
	}

}