<?php

namespace Api;

use Illuminate\Database\Eloquent\SoftDeletingTrait;

class Sector extends Eloquent {

	protected $table = 'sector';
	public $timestamps = true;

	use SoftDeletingTrait;

	protected $dates = ['deleted_at'];
	protected $fillable = array('name', 'bu_director');

	public function projects()
	{
		return $this->hasMany('Project', 'sector_id');
	}

}