<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateOrdersTable extends Migration {

	public function up()
	{
		Schema::create('orders', function(Blueprint $table) {
			$table->increments('id');
			$table->integer('user_id')->unsigned();
			$table->integer('location_id')->unsigned();
			$table->integer('delivery_time_id')->unsigned();
			$table->date('delivery_date');
			$table->enum('delivery_type', array('shipping', 'fromShop'));
			$table->double('subtotal')->default('0.00');
			$table->double('total')->default('0.00');
			$table->bigInteger('status')->unsigned()->default('0');
			$table->text('note')->nullable();
			$table->timestamps();
		});
	}

	public function down()
	{
		Schema::drop('orders');
	}
}