<?php

namespace App\Models;

class Order extends Eloquent {

	protected $table = 'orders';
	public $timestamps = true;

	public function products()
	{
		return $this->belongsToMany('App\Models\Product');
	}

	public function notifications()
	{
		return $this->hasMany('App\Models\Notification');
	}

	public function delivery_time()
	{
		return $this->belongsTo('App\Models\DeliveryTime');
	}

	public function location()
	{
		return $this->belongsTo('App\Models\Location');
	}

}