<?php

namespace App;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class Proyectos extends Model 
{

    protected $table = 'proyectos';
    public $timestamps = true;

    use SoftDeletes;

    protected $dates = ['deleted_at'];

    public function members()
    {
        return $this->hasMany('Proyectos_personas');
    }

    public function createBy()
    {
        return $this->hasOne('Personas');
    }

    public function tasks()
    {
        return $this->hasMany('Tareas');
    }

}