<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Database\Eloquent\Model;

class CreateForeignKeys extends Migration {

	public function up()
	{
		Schema::table('funds', function(Blueprint $table) {
			$table->foreign('donation_id')->references('id')->on('donations')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('funds', function(Blueprint $table) {
			$table->foreign('deduction_id')->references('id')->on('deductions')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('donations', function(Blueprint $table) {
			$table->foreign('user_id')->references('id')->on('users')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
	}

	public function down()
	{
		Schema::table('funds', function(Blueprint $table) {
			$table->dropForeign('funds_donation_id_foreign');
		});
		Schema::table('funds', function(Blueprint $table) {
			$table->dropForeign('funds_deduction_id_foreign');
		});
		Schema::table('donations', function(Blueprint $table) {
			$table->dropForeign('donations_user_id_foreign');
		});
	}
}