<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateInspectionDocSharedTable extends Migration {

	public function up()
	{
		Schema::create('inspection_doc_shared', function(Blueprint $table) {
			$table->increments('id');
			$table->integer('user_id');
			$table->integer('inspection_doc_id');
			$table->boolean('is_doc_downloaded')->default(0);
			$table->datetime('doc_downloaded_at')->nullable();
			$table->timestamps();
			$table->softDeletes();
		});
	}

	public function down()
	{
		Schema::drop('inspection_doc_shared');
	}
}