<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateCategoriesTable extends Migration {

	public function up()
	{
		Schema::create('categories', function(Blueprint $table) {
			$table->increments('id');
			$table->timestamps();
			$table->string('name');
			$table->string('name_en');
			$table->string('vendor_id');
			$table->string('img', 300);
			$table->smallInteger('activity')->default('1');
			$table->integer('parent_id')->default('0');
			$table->smallInteger('has_damages')->default('1');
			$table->smallInteger('has_employees')->default('1');
			$table->smallInteger('has_products')->default('0');
		});
	}

	public function down()
	{
		Schema::drop('categories');
	}
}