<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateLocationsTable extends Migration {

	public function up()
	{
		Schema::create('locations', function(Blueprint $table) {
			$table->increments('id');
			$table->timestamps();
			$table->string('vendor_id');
			$table->string('name');
			$table->string('name_en');
			$table->smallInteger('activity')->default('0');
			$table->integer('user_id');
			$table->date('expired')->nullable();
		});
	}

	public function down()
	{
		Schema::drop('locations');
	}
}