<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreatePropertyImagesTable extends Migration {

	public function up()
	{
		Schema::create('property_images', function(Blueprint $table) {
			$table->increments('id');
			$table->integer('property_id')->unsigned()->index();
			$table->string('image')->nullable();
			$table->enum('status', array('Active', 'Inactive'));
			$table->timestamps();
		});
	}

	public function down()
	{
		Schema::drop('property_images');
	}
}