<?php

namespace App;

use Illuminate\Database\Eloquent\SoftDeletingTrait;

class PropertyModel extends Eloquent {

	protected $table = 'property';
	public $timestamps = true;

	use SoftDeletingTrait;

	protected $dates = ['deleted_at'];

	public function images()
	{
		return $this->hasMany('App\PropertyImagesModel', 'property_id');
	}

	public function type()
	{
		return $this->belongsTo('App\PropertyTypesModel', 'property_type_id');
	}

	public function areaUnit()
	{
		return $this->belongsTo('App\AreaUnitModel', 'area_unit_id');
	}

	public function seller()
	{
		return $this->belongsTo('App\SellerProfileModel', 'seller_id');
	}

}