<?php

namespace App;

use Illuminate\Database\Eloquent\SoftDeletingTrait;

class SellerProfileModel extends Eloquent {

	protected $table = 'seller_profile';
	public $timestamps = true;

	use SoftDeletingTrait;

	protected $dates = ['deleted_at'];

	public function user()
	{
		return $this->belongsTo('App\Users', 'user_id');
	}

	public function properties()
	{
		return $this->hasMany('App\PropertyModel', 'seller_id');
	}

}