<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Database\Eloquent\Model;

class CreateForeignKeys extends Migration {

	public function up()
	{
		Schema::table('block_texts', function(Blueprint $table) {
			$table->foreign('block_page_id')->references('id')->on('blocks')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('blocks', function(Blueprint $table) {
			$table->foreign('right_block_text_id')->references('id')->on('right_block_text')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('videos', function(Blueprint $table) {
			$table->foreign('block_id')->references('id')->on('blocks')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('course_starting', function(Blueprint $table) {
			$table->foreign('course_id')->references('id')->on('courses')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
	}

	public function down()
	{
		Schema::table('block_texts', function(Blueprint $table) {
			$table->dropForeign('block_texts_block_page_id_foreign');
		});
		Schema::table('blocks', function(Blueprint $table) {
			$table->dropForeign('blocks_right_block_text_id_foreign');
		});
		Schema::table('videos', function(Blueprint $table) {
			$table->dropForeign('videos_block_id_foreign');
		});
		Schema::table('course_starting', function(Blueprint $table) {
			$table->dropForeign('course_starting_course_id_foreign');
		});
	}
}