<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateEventsTable extends Migration {

	public function up()
	{
		Schema::create('events', function(Blueprint $table) {
			$table->bigIncrements('id');
			$table->datetime('start_at')->nullable();
			$table->string('title');
			$table->text('description')->nullable();
			$table->string('image')->nullable();
			$table->tinyInteger('published')->default('0');
			$table->tinyInteger('online')->default('0');
			$table->timestamps();
		});
	}

	public function down()
	{
		Schema::drop('events');
	}
}