<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateNotificationsTable extends Migration {

	public function up()
	{
		Schema::create('notifications', function(Blueprint $table) {
			$table->uuid('id')->primary();
			$table->bigInteger('notifiable_id')->unsigned();
			$table->string('notifiable_type', 255);
			$table->string('title');
			$table->text('body');
			$table->json('data')->nullable();
			$table->datetime('read_at')->nullable();
			$table->timestamps();
		});
	}

	public function down()
	{
		Schema::drop('notifications');
	}
}