<?php

namespace Models/NetworkApiCredentials;

use Illuminate\Database\Eloquent\SoftDeletingTrait;

class NetworkApiCredentials extends Eloquent {

	protected $table = 'network_api_credentials';
	public $timestamps = true;

	use SoftDeletingTrait;

	protected $dates = ['deleted_at'];

	public function getCustomer()
	{
		return $this->belongsTo('Customers');
	}

	public function getNetorks()
	{
		return $this->belongsTo('Networks');
	}

}