<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateEntitiesTable extends Migration {

	public function up()
	{
		Schema::create('entities', function(Blueprint $table) {
			$table->bigIncrements('id');
			$table->char('ulid', 26)->unique()->nullable();
			$table->string('code', 50)->index();
			$table->string('name')->index();
			$table->string('description')->nullable();
			$table->string('parent', 50)->nullable()->index();
			$table->integer('level')->unsigned()->default('0');
			$table->string('type', 20)->default('default');
			$table->integer('group_id')->unsigned()->index()->default('0');
			$table->jsonb('properties')->nullable();
			$table->string('status', 25)->index()->default('draft');
			$table->softDeletes();
			$table->timestamps();
		});
	}

	public function down()
	{
		Schema::drop('entities');
	}
}