<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreatePeriodsTable extends Migration {

	public function up()
	{
		Schema::create('periods', function(Blueprint $table) {
			$table->bigIncrements('id');
			$table->char('ulid', 26)->unique();
			$table->string('code', 50)->nullable();
			$table->string('name', 150);
			$table->string('description')->nullable();
			$table->datetimeTz('date_start');
			$table->datetimeTz('date_end');
			$table->integer('group_id')->unsigned()->index()->default('0');
			$table->string('status', 20)->default('active');
			$table->jsonb('properties')->nullable();
			$table->softDeletes();
			$table->timestamps();
		});
	}

	public function down()
	{
		Schema::drop('periods');
	}
}