<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateTaxonomiesTable extends Migration {

	public function up()
	{
		Schema::create('taxonomies', function(Blueprint $table) {
			$table->bigIncrements('id');
			$table->char('ulid', 26);
			$table->string('code', 50)->nullable();
			$table->string('name', 150);
			$table->string('description')->nullable();
			$table->integer('parent')->index()->default('0');
			$table->integer('level')->default('0');
			$table->string('type', 20)->default('system');
			$table->smallInteger('sort_order')->default('0');
			$table->integer('group_id')->unsigned()->index()->default('0');
			$table->jsonb('properties')->nullable();
			$table->string('status', 20)->default('active');
			$table->softDeletes();
			$table->timestamps();
		});
	}

	public function down()
	{
		Schema::drop('taxonomies');
	}
}