<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateUsersTable extends Migration {

	public function up()
	{
		Schema::create('Users', function(Blueprint $table) {
			$table->bigIncrements('id');
			$table->char('ulid', 26)->unique();
			$table->string('name', 192);
			$table->string('email')->unique();
			$table->string('password');
			$table->jsonb('properties')->nullable();
			$table->string('status', 25)->default('ac');
			$table->string('remember_token', 100)->nullable();
			$table->timestamp('created_at')->nullable();
			$table->timestamp('updated_at')->nullable();
			$table->softDeletes();
			$table->timestamps();
		});
	}

	public function down()
	{
		Schema::drop('Users');
	}
}