<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateWorkflowsTable extends Migration {

	public function up()
	{
		Schema::create('workflows', function(Blueprint $table) {
			$table->increments('id');
			$table->char('ulid', 26);
			$table->string('code', 50)->nullable();
			$table->string('name');
			$table->string('description')->nullable();
			$table->integer('taxonomy_id')->unsigned()->index();
			$table->integer('taxonomy_status_type_id')->unsigned()->index();
			$table->integer('group_id')->unsigned();
			$table->jsonb('properties')->nullable();
			$table->string('status', 20)->default('active');
			$table->softDeletes();
			$table->timestamps();
		});
	}

	public function down()
	{
		Schema::drop('workflows');
	}
}