<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateAddressesTable extends Migration {

	public function up()
	{
		Schema::create('addresses', function(Blueprint $table) {
			$table->increments('id');
			$table->integer('city_id');
			$table->tinyInteger('is_saved')->default('0');
			$table->string('title');
			$table->text('description');
			$table->string('addressable_type');
			$table->integer('addressable_id');
			$table->timestamps();
		});
	}

	public function down()
	{
		Schema::drop('addresses');
	}
}