<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateMonthlyBillsTable extends Migration {

	public function up()
	{
		Schema::create('monthly_bills', function(Blueprint $table) {
			$table->increments('id');
			$table->timestamps();
			$table->integer('store_id')->unsigned();
			$table->integer('service_id')->unsigned();
			$table->date('billing_month');
			$table->decimal('amount');
			$table->date('due_date');
			$table->enum('payment_status', array('pending', 'paid', 'overdue', 'cancel'));
			$table->timestamp('paid_at')->nullable();
		});
	}

	public function down()
	{
		Schema::drop('monthly_bills');
	}
}