<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateBusinessCategoriesTable extends Migration {

	public function up()
	{
		Schema::create('business_categories', function(Blueprint $table) {
			$table->increments('id');
			$table->timestamps();
			$table->integer('business_type_id')->unsigned();
			$table->string('name');
			$table->string('description')->nullable();
			$table->boolean('is_active')->default(true);
		});
	}

	public function down()
	{
		Schema::drop('business_categories');
	}
}