<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Database\Eloquent\Model;

class CreateForeignKeys extends Migration {

	public function up()
	{
		Schema::table('targets', function(Blueprint $table) {
			$table->foreign('target_type_id')->references('id')->on('target_types')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('target_progress_logs', function(Blueprint $table) {
			$table->foreign('target_id')->references('id')->on('targets')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('target_assignments', function(Blueprint $table) {
			$table->foreign('target_id')->references('id')->on('targets')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('target_templates', function(Blueprint $table) {
			$table->foreign('target_type_id')->references('id')->on('target_types')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
	}

	public function down()
	{
		Schema::table('targets', function(Blueprint $table) {
			$table->dropForeign('targets_target_type_id_foreign');
		});
		Schema::table('target_progress_logs', function(Blueprint $table) {
			$table->dropForeign('target_progress_logs_target_id_foreign');
		});
		Schema::table('target_assignments', function(Blueprint $table) {
			$table->dropForeign('target_assignments_target_id_foreign');
		});
		Schema::table('target_templates', function(Blueprint $table) {
			$table->dropForeign('target_templates_target_type_id_foreign');
		});
	}
}