<?php

use Illuminate\Database\Eloquent\SoftDeletingTrait;

class TargetAssignments extends Eloquent {

	protected $table = 'target_assignments';
	public $timestamps = true;

	use SoftDeletingTrait;

	protected $dates = ['deleted_at'];

	public function assignable()
	{
		return $this->morphTo();
	}

	public function target()
	{
		return $this->belongsTo('Target');
	}

	public function progressLogs()
	{
		return $this->hasMany('TargetProgressLogs');
	}

}