<?php

use Illuminate\Database\Eloquent\SoftDeletingTrait;

class TargetProgressLogs extends Eloquent {

	protected $table = 'target_progress_logs';
	public $timestamps = true;

	use SoftDeletingTrait;

	protected $dates = ['deleted_at'];

	public function target()
	{
		return $this->belongsTo('Target');
	}

	public function progressable()
	{
		return $this->morphTo();
	}

	public function assignment()
	{
		return $this->belongsTo('TargetAssignments');
	}

}