<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateTargetTemplatesTable extends Migration {

	public function up()
	{
		Schema::create('target_templates', function(Blueprint $table) {
			$table->increments('id');
			$table->timestamps();
			$table->string('name');
			$table->integer('target_type_id')->unsigned();
			$table->enum('period_type', array(''daily'', ''weekly'', ''monthly'', ''quarterly'', ''yearly''));
			$table->decimal('default_value');
			$table->boolean('auto_distribute');
			$table->boolean('is_auto_accept');
			$table->longText('description');
		});
	}

	public function down()
	{
		Schema::drop('target_templates');
	}
}