<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Database\Eloquent\Model;

class CreateForeignKeys extends Migration {

	public function up()
	{
		Schema::table('courses', function(Blueprint $table) {
			$table->foreign('teacher_id')->references('id')->on('teachers')
						->onDelete('cascade')
						->onUpdate('restrict');
		});
		Schema::table('courses', function(Blueprint $table) {
			$table->foreign('category_id')->references('id')->on('categories')
						->onDelete('cascade')
						->onUpdate('restrict');
		});
		Schema::table('courses', function(Blueprint $table) {
			$table->foreign('duration_id')->references('id')->on('durations')
						->onDelete('cascade')
						->onUpdate('restrict');
		});
		Schema::table('course_room', function(Blueprint $table) {
			$table->foreign('course_id')->references('id')->on('courses')
						->onDelete('cascade')
						->onUpdate('restrict');
		});
		Schema::table('course_room', function(Blueprint $table) {
			$table->foreign('room_id')->references('id')->on('categories')
						->onDelete('cascade')
						->onUpdate('restrict');
		});
		Schema::table('course_student', function(Blueprint $table) {
			$table->foreign('course_id')->references('id')->on('courses')
						->onDelete('cascade')
						->onUpdate('restrict');
		});
		Schema::table('course_student', function(Blueprint $table) {
			$table->foreign('student_id')->references('id')->on('students')
						->onDelete('cascade')
						->onUpdate('restrict');
		});
		Schema::table('register', function(Blueprint $table) {
			$table->foreign('course_id')->references('id')->on('courses')
						->onDelete('cascade')
						->onUpdate('restrict');
		});
	}

	public function down()
	{
		Schema::table('courses', function(Blueprint $table) {
			$table->dropForeign('courses_teacher_id_foreign');
		});
		Schema::table('courses', function(Blueprint $table) {
			$table->dropForeign('courses_category_id_foreign');
		});
		Schema::table('courses', function(Blueprint $table) {
			$table->dropForeign('courses_duration_id_foreign');
		});
		Schema::table('course_room', function(Blueprint $table) {
			$table->dropForeign('course_room_course_id_foreign');
		});
		Schema::table('course_room', function(Blueprint $table) {
			$table->dropForeign('course_room_room_id_foreign');
		});
		Schema::table('course_student', function(Blueprint $table) {
			$table->dropForeign('course_student_course_id_foreign');
		});
		Schema::table('course_student', function(Blueprint $table) {
			$table->dropForeign('course_student_student_id_foreign');
		});
		Schema::table('register', function(Blueprint $table) {
			$table->dropForeign('register_course_id_foreign');
		});
	}
}