<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Database\Eloquent\Model;

class CreateForeignKeys extends Migration {

	public function up()
	{
		Schema::table('companies', function(Blueprint $table) {
			$table->foreign('region_id')->references('id')->on('regions')
						->onDelete('set null')
						->onUpdate('no action');
		});
		Schema::table('companies', function(Blueprint $table) {
			$table->foreign('sector_id')->references('id')->on('business_lines')
						->onDelete('set null')
						->onUpdate('no action');
		});
		Schema::table('companies', function(Blueprint $table) {
			$table->foreign('user_id')->references('id')->on('users')
						->onDelete('set null')
						->onUpdate('no action');
		});
		Schema::table('employees', function(Blueprint $table) {
			$table->foreign('company_id')->references('id')->on('companies')
						->onDelete('set null')
						->onUpdate('no action');
		});
		Schema::table('companies_indicators', function(Blueprint $table) {
			$table->foreign('company_id')->references('id')->on('companies')
						->onDelete('cascade')
						->onUpdate('no action');
		});
		Schema::table('companies_indicators', function(Blueprint $table) {
			$table->foreign('indicator_id')->references('id')->on('indicators')
						->onDelete('cascade')
						->onUpdate('no action');
		});
		Schema::table('employees_jobs', function(Blueprint $table) {
			$table->foreign('employee_id')->references('id')->on('employees')
						->onDelete('cascade')
						->onUpdate('no action');
		});
		Schema::table('employees_jobs', function(Blueprint $table) {
			$table->foreign('business_branches_id')->references('id')->on('business_branches')
						->onDelete('set null')
						->onUpdate('no action');
		});
		Schema::table('employees_jobs', function(Blueprint $table) {
			$table->foreign('business_job_id')->references('id')->on('business_jobs')
						->onDelete('set null')
						->onUpdate('no action');
		});
		Schema::table('employees_jobs', function(Blueprint $table) {
			$table->foreign('ending_argument_id')->references('id')->on('ending_arguments')
						->onDelete('set null')
						->onUpdate('no action');
		});
		Schema::table('employees_formations', function(Blueprint $table) {
			$table->foreign('employee_id')->references('id')->on('employees')
						->onDelete('cascade')
						->onUpdate('no action');
		});
		Schema::table('employees_conflicts', function(Blueprint $table) {
			$table->foreign('employee_id')->references('id')->on('employees')
						->onDelete('cascade')
						->onUpdate('no action');
		});
		Schema::table('employees_absenteeisms', function(Blueprint $table) {
			$table->foreign('employee_id')->references('id')->on('employees')
						->onDelete('cascade')
						->onUpdate('no action');
		});
		Schema::table('employees_formations_absenteeisms', function(Blueprint $table) {
			$table->foreign('formation_id')->references('id')->on('employees_formations')
						->onDelete('cascade')
						->onUpdate('no action');
		});
		Schema::table('business_branches', function(Blueprint $table) {
			$table->foreign('company_id')->references('id')->on('companies')
						->onDelete('cascade')
						->onUpdate('no action');
		});
		Schema::table('business_jobs', function(Blueprint $table) {
			$table->foreign('company_id')->references('id')->on('companies')
						->onDelete('cascade')
						->onUpdate('no action');
		});
		Schema::table('business_branches_jobs', function(Blueprint $table) {
			$table->foreign('business_branch_id')->references('id')->on('business_branches')
						->onDelete('cascade')
						->onUpdate('no action');
		});
		Schema::table('business_branches_jobs', function(Blueprint $table) {
			$table->foreign('business_job_id')->references('id')->on('business_jobs')
						->onDelete('cascade')
						->onUpdate('no action');
		});
	}

	public function down()
	{
		Schema::table('companies', function(Blueprint $table) {
			$table->dropForeign('companies_region_id_foreign');
		});
		Schema::table('companies', function(Blueprint $table) {
			$table->dropForeign('companies_sector_id_foreign');
		});
		Schema::table('companies', function(Blueprint $table) {
			$table->dropForeign('companies_user_id_foreign');
		});
		Schema::table('employees', function(Blueprint $table) {
			$table->dropForeign('employees_company_id_foreign');
		});
		Schema::table('companies_indicators', function(Blueprint $table) {
			$table->dropForeign('companies_indicators_company_id_foreign');
		});
		Schema::table('companies_indicators', function(Blueprint $table) {
			$table->dropForeign('companies_indicators_indicator_id_foreign');
		});
		Schema::table('employees_jobs', function(Blueprint $table) {
			$table->dropForeign('employees_jobs_employee_id_foreign');
		});
		Schema::table('employees_jobs', function(Blueprint $table) {
			$table->dropForeign('employees_jobs_business_branches_id_foreign');
		});
		Schema::table('employees_jobs', function(Blueprint $table) {
			$table->dropForeign('employees_jobs_business_job_id_foreign');
		});
		Schema::table('employees_jobs', function(Blueprint $table) {
			$table->dropForeign('employees_jobs_ending_argument_id_foreign');
		});
		Schema::table('employees_formations', function(Blueprint $table) {
			$table->dropForeign('employees_formations_employee_id_foreign');
		});
		Schema::table('employees_conflicts', function(Blueprint $table) {
			$table->dropForeign('employees_conflicts_employee_id_foreign');
		});
		Schema::table('employees_absenteeisms', function(Blueprint $table) {
			$table->dropForeign('employees_absenteeisms_employee_id_foreign');
		});
		Schema::table('employees_formations_absenteeisms', function(Blueprint $table) {
			$table->dropForeign('employees_formations_absenteeisms_formation_id_foreign');
		});
		Schema::table('business_branches', function(Blueprint $table) {
			$table->dropForeign('business_branches_company_id_foreign');
		});
		Schema::table('business_jobs', function(Blueprint $table) {
			$table->dropForeign('business_jobs_company_id_foreign');
		});
		Schema::table('business_branches_jobs', function(Blueprint $table) {
			$table->dropForeign('business_branches_jobs_business_branch_id_foreign');
		});
		Schema::table('business_branches_jobs', function(Blueprint $table) {
			$table->dropForeign('business_branches_jobs_business_job_id_foreign');
		});
	}
}