<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateUsersTable extends Migration {

	public function up()
	{
		Schema::create('users', function(Blueprint $table) {
			$table->increments('id');
			$table->string('name');
			$table->integer('user_type_id')->unsigned()->nullable();
			$table->string('phone')->unique();
			$table->string('password');
			$table->string('email')->unique();
			$table->tinyInteger('phone_verified')->default('0');
			$table->tinyInteger('status')->default('0');
			$table->string('api_token')->nullable();
			$table->string('device_token')->nullable();
			$table->string('device_type')->nullable();
			$table->integer('state_id')->unsigned()->nullable();
			$table->integer('city_id')->unsigned()->nullable();
			$table->timestamps();
		});
	}

	public function down()
	{
		Schema::drop('users');
	}
}