<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Database\Eloquent\Model;

class CreateForeignKeys extends Migration {

	public function up()
	{
		Schema::table('users', function(Blueprint $table) {
			$table->foreign('user_type_id')->references('id')->on('user_types')
						->onDelete('set null')
						->onUpdate('no action');
		});
		Schema::table('users', function(Blueprint $table) {
			$table->foreign('state_id')->references('id')->on('states')
						->onDelete('set null')
						->onUpdate('no action');
		});
		Schema::table('users', function(Blueprint $table) {
			$table->foreign('city_id')->references('id')->on('cities')
						->onDelete('set null')
						->onUpdate('no action');
		});
		Schema::table('user_type_translations', function(Blueprint $table) {
			$table->foreign('user_type_id')->references('id')->on('user_types')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('assistant_doctors', function(Blueprint $table) {
			$table->foreign('assistant_id')->references('id')->on('assistant')
						->onDelete('cascade')
						->onUpdate('no action');
		});
		Schema::table('assistant_doctors', function(Blueprint $table) {
			$table->foreign('doctor_id')->references('id')->on('doctors')
						->onDelete('cascade')
						->onUpdate('no action');
		});
		Schema::table('specialization_translations', function(Blueprint $table) {
			$table->foreign('specialization_id')->references('id')->on('specializations')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('state_translations', function(Blueprint $table) {
			$table->foreign('state_id')->references('id')->on('states')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('city_translations', function(Blueprint $table) {
			$table->foreign('city_id')->references('id')->on('cities')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('doctor_specializtions', function(Blueprint $table) {
			$table->foreign('doctor_id')->references('id')->on('doctors')
						->onDelete('cascade')
						->onUpdate('no action');
		});
		Schema::table('doctor_specializtions', function(Blueprint $table) {
			$table->foreign('specialization_id')->references('id')->on('specializations')
						->onDelete('cascade')
						->onUpdate('no action');
		});
		Schema::table('operation_name_translations', function(Blueprint $table) {
			$table->foreign('operation_name_id')->references('id')->on('operation_names')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('operations', function(Blueprint $table) {
			$table->foreign('doctor_id')->references('id')->on('doctors')
						->onDelete('set null')
						->onUpdate('no action');
		});
		Schema::table('operations', function(Blueprint $table) {
			$table->foreign('patient_id')->references('id')->on('patients')
						->onDelete('set null')
						->onUpdate('no action');
		});
		Schema::table('operations', function(Blueprint $table) {
			$table->foreign('operation_name_id')->references('id')->on('operation_names')
						->onDelete('set null')
						->onUpdate('no action');
		});
		Schema::table('operations', function(Blueprint $table) {
			$table->foreign('workspace_id')->references('id')->on('workspaces')
						->onDelete('set null')
						->onUpdate('no action');
		});
		Schema::table('drug_translations', function(Blueprint $table) {
			$table->foreign('drug_id')->references('id')->on('drugs')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('drug_strength_translations', function(Blueprint $table) {
			$table->foreign('drug_strength_id')->references('id')->on('drug_strengths')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('drug_type_translations', function(Blueprint $table) {
			$table->foreign('drug_type_id')->references('id')->on('drug_types')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('drug_repeat_translations', function(Blueprint $table) {
			$table->foreign('drug_repeat_id')->references('id')->on('drug_repeats')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('operation_drugs', function(Blueprint $table) {
			$table->foreign('operation_id')->references('id')->on('operations')
						->onDelete('cascade')
						->onUpdate('no action');
		});
		Schema::table('operation_drugs', function(Blueprint $table) {
			$table->foreign('drug_id')->references('id')->on('drugs')
						->onDelete('set null')
						->onUpdate('no action');
		});
		Schema::table('operation_drugs', function(Blueprint $table) {
			$table->foreign('drug_strength_id')->references('id')->on('drug_strengths')
						->onDelete('set null')
						->onUpdate('no action');
		});
		Schema::table('operation_drugs', function(Blueprint $table) {
			$table->foreign('drug_type_id')->references('id')->on('drug_types')
						->onDelete('set null')
						->onUpdate('no action');
		});
		Schema::table('operation_drugs', function(Blueprint $table) {
			$table->foreign('drug_repeat_id')->references('id')->on('drug_repeats')
						->onDelete('set null')
						->onUpdate('no action');
		});
		Schema::table('chats', function(Blueprint $table) {
			$table->foreign('from_user_id')->references('id')->on('users')
						->onDelete('cascade')
						->onUpdate('no action');
		});
		Schema::table('chats', function(Blueprint $table) {
			$table->foreign('to_user_id')->references('id')->on('users')
						->onDelete('cascade')
						->onUpdate('no action');
		});
		Schema::table('workspace_translations', function(Blueprint $table) {
			$table->foreign('workspace_id')->references('id')->on('workspaces')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('notifications', function(Blueprint $table) {
			$table->foreign('user_id')->references('id')->on('users')
						->onDelete('cascade')
						->onUpdate('no action');
		});
		Schema::table('question_translations', function(Blueprint $table) {
			$table->foreign('question_id')->references('id')->on('questions')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('slider_translations', function(Blueprint $table) {
			$table->foreign('slider_id')->references('id')->on('sliders')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('setting_translations', function(Blueprint $table) {
			$table->foreign('setting_id')->references('id')->on('settings')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
	}

	public function down()
	{
		Schema::table('users', function(Blueprint $table) {
			$table->dropForeign('users_user_type_id_foreign');
		});
		Schema::table('users', function(Blueprint $table) {
			$table->dropForeign('users_state_id_foreign');
		});
		Schema::table('users', function(Blueprint $table) {
			$table->dropForeign('users_city_id_foreign');
		});
		Schema::table('user_type_translations', function(Blueprint $table) {
			$table->dropForeign('user_type_translations_user_type_id_foreign');
		});
		Schema::table('assistant_doctors', function(Blueprint $table) {
			$table->dropForeign('assistant_doctors_assistant_id_foreign');
		});
		Schema::table('assistant_doctors', function(Blueprint $table) {
			$table->dropForeign('assistant_doctors_doctor_id_foreign');
		});
		Schema::table('specialization_translations', function(Blueprint $table) {
			$table->dropForeign('specialization_translations_specialization_id_foreign');
		});
		Schema::table('state_translations', function(Blueprint $table) {
			$table->dropForeign('state_translations_state_id_foreign');
		});
		Schema::table('city_translations', function(Blueprint $table) {
			$table->dropForeign('city_translations_city_id_foreign');
		});
		Schema::table('doctor_specializtions', function(Blueprint $table) {
			$table->dropForeign('doctor_specializtions_doctor_id_foreign');
		});
		Schema::table('doctor_specializtions', function(Blueprint $table) {
			$table->dropForeign('doctor_specializtions_specialization_id_foreign');
		});
		Schema::table('operation_name_translations', function(Blueprint $table) {
			$table->dropForeign('operation_name_translations_operation_name_id_foreign');
		});
		Schema::table('operations', function(Blueprint $table) {
			$table->dropForeign('operations_doctor_id_foreign');
		});
		Schema::table('operations', function(Blueprint $table) {
			$table->dropForeign('operations_patient_id_foreign');
		});
		Schema::table('operations', function(Blueprint $table) {
			$table->dropForeign('operations_operation_name_id_foreign');
		});
		Schema::table('operations', function(Blueprint $table) {
			$table->dropForeign('operations_workspace_id_foreign');
		});
		Schema::table('drug_translations', function(Blueprint $table) {
			$table->dropForeign('drug_translations_drug_id_foreign');
		});
		Schema::table('drug_strength_translations', function(Blueprint $table) {
			$table->dropForeign('drug_strength_translations_drug_strength_id_foreign');
		});
		Schema::table('drug_type_translations', function(Blueprint $table) {
			$table->dropForeign('drug_type_translations_drug_type_id_foreign');
		});
		Schema::table('drug_repeat_translations', function(Blueprint $table) {
			$table->dropForeign('drug_repeat_translations_drug_repeat_id_foreign');
		});
		Schema::table('operation_drugs', function(Blueprint $table) {
			$table->dropForeign('operation_drugs_operation_id_foreign');
		});
		Schema::table('operation_drugs', function(Blueprint $table) {
			$table->dropForeign('operation_drugs_drug_id_foreign');
		});
		Schema::table('operation_drugs', function(Blueprint $table) {
			$table->dropForeign('operation_drugs_drug_strength_id_foreign');
		});
		Schema::table('operation_drugs', function(Blueprint $table) {
			$table->dropForeign('operation_drugs_drug_type_id_foreign');
		});
		Schema::table('operation_drugs', function(Blueprint $table) {
			$table->dropForeign('operation_drugs_drug_repeat_id_foreign');
		});
		Schema::table('chats', function(Blueprint $table) {
			$table->dropForeign('chats_from_user_id_foreign');
		});
		Schema::table('chats', function(Blueprint $table) {
			$table->dropForeign('chats_to_user_id_foreign');
		});
		Schema::table('workspace_translations', function(Blueprint $table) {
			$table->dropForeign('workspace_translations_workspace_id_foreign');
		});
		Schema::table('notifications', function(Blueprint $table) {
			$table->dropForeign('notifications_user_id_foreign');
		});
		Schema::table('question_translations', function(Blueprint $table) {
			$table->dropForeign('question_translations_question_id_foreign');
		});
		Schema::table('slider_translations', function(Blueprint $table) {
			$table->dropForeign('slider_translations_slider_id_foreign');
		});
		Schema::table('setting_translations', function(Blueprint $table) {
			$table->dropForeign('setting_translations_setting_id_foreign');
		});
	}
}