<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreatePartnersAutoInvoiceTable extends Migration {

	public function up()
	{
		Schema::create('partnersAutoInvoice', function(Blueprint $table) {
			$table->increments('id');
			$table->timestamps();
			$table->integer('partnerId');
			$table->enum('Typ', array('auto', 'manual'));
			$table->boolean('needDeliveryNote');
			$table->boolean('sendMail');
			$table->json('mailList')->nullable();
			$table->json('automatizationOptions')->nullable();
		});
	}

	public function down()
	{
		Schema::drop('partnersAutoInvoice');
	}
}