<?php

namespace Api;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class Project extends Model 
{

    protected $table = 'project';
    public $timestamps = true;

    use SoftDeletes;

    protected $dates = ['deleted_at'];
    protected $fillable = array('name', 'user_id');

    public function phases()
    {
        return $this->hasMany('Phase', 'project_id');
    }

    public function user()
    {
        return $this->belongsTo('User', 'user_id');
    }

}