<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateCertificatesTable extends Migration {

	public function up()
	{
		Schema::create('certificates', function(Blueprint $table) {
			$table->increments('id');
			$table->integer('course_id')->unsigned();
			$table->integer('batch_id')->unsigned()->nullable();
			$table->enum('type', array('0', '1'));
			$table->string('certificate')->nullable();
			$table->integer('created_by')->nullable();
			$table->string('created_slug')->nullable();
			$table->timestamps();
			$table->softDeletes();
		});
	}

	public function down()
	{
		Schema::drop('certificates');
	}
}