<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateDoubtsTable extends Migration {

	public function up()
	{
		Schema::create('doubts', function(Blueprint $table) {
			$table->increments('id');
			$table->integer('lesson_id')->unsigned();
			$table->integer('staff_id')->unsigned();
			$table->integer('student_id')->unsigned();
			$table->string('ques');
			$table->string('ques_image');
			$table->string('answer')->nullable();
			$table->string('answer_image')->nullable();
			$table->tinyInteger('is_active')->default('1');
			$table->tinyInteger('is_solved')->default('0');
			$table->timestamp('closed_on')->nullable();
			$table->timestamps();
			$table->softDeletes();
		});
	}

	public function down()
	{
		Schema::drop('doubts');
	}
}