<?php

namespace BESTSELLER;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class FinancialAccount extends Model 
{

    protected $table = 'FinancialAccounts';
    public $timestamps = true;

    use SoftDeletes;

    protected $dates = ['deleted_at'];
    protected $fillable = array('AccountID', 'Name');
    protected $visible = array('AccountID', 'Name');

    public function FinancialData()
    {
        return $this->hasMany('BESTSELLER\FinancialData', 'AccountID', 'FinancialAccount');
    }

}