<?php

namespace BESTSELLER;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class SalesData extends Model 
{

    protected $table = 'SalesData';
    public $timestamps = true;

    use SoftDeletes;

    protected $dates = ['deleted_at'];
    protected $fillable = array('CostCenter', 'Month', 'Year', 'GrossSales', 'GrossProfit', 'BasketSize', 'BasketQty', 'SalesPriceAvg', 'Transactions', 'ConversionRate', 'CustomerCount', 'SalesType');
    protected $visible = array('CostCenter', 'Month', 'Year', 'GrossSales', 'GrossProfit', 'BasketSize', 'BasketQty', 'SalesPriceAvg', 'Transactions', 'ConversionRate', 'CustomerCount', 'SalesType');

    public function Store()
    {
        return $this->belongsTo('BESTSELLER\StoreData', 'CostCenter', 'CostCenter');
    }

}