<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateStoresDataTable extends Migration {

	public function up()
	{
		Schema::create('StoresData', function(Blueprint $table) {
			$table->increments('id');
			$table->integer('CostCenter')->nullable();
			$table->integer('ChainNum');
			$table->string('ChainSlug', 10);
			$table->string('StoreName', 255)->nullable();
			$table->string('RepCode', 100)->nullable();
			$table->string('ContractNo', 100)->nullable();
			$table->string('AreaManager', 255)->nullable();
			$table->string('StoreFront', 10)->nullable();
			$table->string('LocationType', 100)->nullable();
			$table->string('State', 255)->nullable();
			$table->integer('PosCount')->default('1');
			$table->integer('SQMContract')->nullable();
			$table->integer('SQMSales')->nullable();
			$table->integer('RentSplit')->nullable();
			$table->boolean('Top50JJ')->default(False);
			$table->decimal('StaffPerOpeningHours')->nullable();
			$table->boolean('OpenStoreVM')->default(False);
			$table->boolean('ComparableStatus')->default(True);
			$table->string('StatusType', 255)->nullable();
			$table->date('ContractDate')->nullable();
			$table->date('ShopDate')->nullable();
			$table->date('TempClosingStartDate')->nullable();
			$table->date('TempClosingEndDate')->nullable();
			$table->date('RentContractStart')->nullable();
			$table->date('RentContractEnd')->nullable();
			$table->decimal('RentStore')->nullable();
			$table->decimal('RentStorage')->nullable();
			$table->decimal('RentOperationalCost')->nullable();
			$table->timestamps();
			$table->softDeletes();
		});
	}

	public function down()
	{
		Schema::drop('StoresData');
	}
}