<?php

namespace BESTSELLER;

use Illuminate\Database\Eloquent\SoftDeletingTrait;

class Depreciation extends Eloquent {

	protected $table = 'DepreciationData';
	public $timestamps = true;

	use SoftDeletingTrait;

	protected $dates = ['deleted_at'];
	protected $fillable = array('CostCenter', 'Month', 'Year', 'Value');
	protected $visible = array('CostCenter', 'Month', 'Year', 'Value');

	public function Store()
	{
		return $this->belongsTo('BESTSELLER\StoreData', 'CostCenter', 'CostCenter');
	}

}