<?php

namespace BESTSELLER;

use Illuminate\Database\Eloquent\SoftDeletingTrait;

class SalesData extends Eloquent {

	protected $table = 'SalesData';
	public $timestamps = true;

	use SoftDeletingTrait;

	protected $dates = ['deleted_at'];
	protected $fillable = array('CostCenter', 'Month', 'Year', 'GrossSales', 'GrossProfit', 'BasketSize', 'BasketQty', 'SalesPriceAvg', 'Transactions', 'ConversionRate', 'CustomerCount', 'SalesType');
	protected $visible = array('CostCenter', 'Month', 'Year', 'GrossSales', 'GrossProfit', 'BasketSize', 'BasketQty', 'SalesPriceAvg', 'Transactions', 'ConversionRate', 'CustomerCount', 'SalesType');

	public function Store()
	{
		return $this->belongsTo('BESTSELLER\StoreData', 'CostCenter', 'CostCenter');
	}

}